#ifndef _HNFSFLT_H
#define _HNFSFLT_H 1

#include <linux/module.h>	/* Needed by all modules */
#include <linux/kernel.h>	/* Needed for KERN_INFO */
#include <linux/init.h>		/* Needed for the macros */
#include <linux/fs.h>
#include <linux/sched.h>	/* Needed for dev poll */
#include <linux/poll.h>
#include <asm/uaccess.h>	/* for put_user */
#include <linux/slab.h>	 /* for kmalloc/kfree */

#include "redirfs.h"


#define HNFSFLT_VERSION "15"
#define DEVICE_NAME "hnfsflt"	/* Dev appears as /proc/devices/hnfsflt */
#define RBUF_SIZE (PAGE_SIZE/sizeof(void *))	/* number of entries in ring buffer */


/* Module-global variables */
extern redirfs_filter hnfsflt;
extern atomic_t hnfsflt_device_major;
extern wait_queue_head_t read_waitq;
extern atomic_t hnfsflt_noll; /* number of loglines in the ring buffer */


/* Data structures */
struct hnfsflt_logline {
	/* Required by redirfs to store a log line as opaque data */
	struct redirfs_data rfs_data;

	int pos; /* for reading in chunks */

	/*
	 * 'R' regular file
	 * 'L' symbolic link
	 * 'D' directory
	 * 'U' unknown
	 */
	char type;

	/*
	 * 'C' create
	 * 'D' delete
	 * 'W' write
	 * 'A' change attributes
	 * 'O' rename/move out (prev path and/or name)
	 * 'I' rename/move in  (new  path and/or name)
	 * 'X' setxattr
	 * 'Y' removexattr
	 */
	char op;


	size_t flen; /* ino, dev and path are followed by each other in memory */
	char *ino;
	char *dev;
	char *path;
};


struct hnfsflt_logline * hnfsflt_ll_alloc(
	const char type, const char op, const unsigned long ino, const unsigned long dev, const char *path);
void hnfsflt_ll_free(struct hnfsflt_logline *);
void hnfsflt_ll_insert(struct hnfsflt_logline *logline);
struct hnfsflt_logline *hnfsflt_ll_take(const int may_block);


int hnfsflt_sys_init(void);
void hnfsflt_sys_cleanup(void);

int hnfsflt_dev_init(void);
void hnfsflt_dev_cleanup(void);

int hnfsflt_data_init(void);
void hnfsflt_data_cleanup(void);
int test_and_clear_ll_dropped(void);

int hnfsflt_rfs_init(void);
void hnfsflt_rfs_cleanup(void);

#endif
